jQuery(function ($) {

  var Difi3 = {
    config: {},

    init: function (config) {
      this.addBootstrapBreakpointDetection();
      this.mobileMenu();
      this.imageToFigure();
      this.figureResize();
      this.accordion();
      this.tableToResponsive();
      this.fileDownloadIcon();
      this.boxArticleListLink();
      this.boxTransportPageListLink();
      this.scrollToTop();
      this.onLocationHash();
      this.scrollToAnchor();
      this.mobileSearchForm();
      this.fluidVideoSetAspectRatio();
      this.fluidVideoSetWidthAndHeight();
      this.keyfigure();
      this.listPage();
      this.euCookiePrivacy();
      this.warningEnvironment();
      this.sitemapAlphabeticNavigation();
      this.popover();
      this.resizer();
    },

    /**
     * Setup mobile menu
     */
    mobileMenu: function () {
      $("nav ul.menu:first").attr('data-breakpoint', '991'); // Add breakpoint
      $("nav ul.menu:first").flexNav(); // Activate mobile menu

      $("nav .menu-button .touch-button").html('<div class="navicon-line"></div><div class="navicon-line"></div><div class="navicon-line"></div>'); // Add navicon line

      // Add span for text styling
      $("nav ul.menu a").each(function (index) {
        $(this).html('<span>' + $(this).text() + '</span>');
      });

      // Expand active items in menu
      $("nav ul.menu li.active-trail > .touch-button").trigger("click");
    },

    /**
     * Transform HTML img to HTML 5 figure
     */
    imageToFigure: function () {
      $("#content article img.figure").each(function (index) {
        var img_src = $(this).attr('src');
        var img_title = $(this).attr('title');
        var img_alt = $(this).attr('alt');
        var img_class = $(this).attr('class');
        var img_figure;

        img_figure = '<figure';

        if (img_class) {
          img_figure += ' class="' + img_class + '"';
        }

        img_figure += '>';

        img_figure += '<img src="' + img_src + '" alt="' + img_alt + '" title="' + img_title + '" />';

        if ((img_alt && !$(this).hasClass('hide-alt')) || img_title) {
          img_figure += '<figcaption>';
          if (img_title) {
            img_figure += '<div class="title"><p>' + img_title + '</p></div>';
          }
          if (img_alt && !$(this).hasClass('hide-alt')) {
            img_figure += '<div class="body"><p>' + img_alt + '</p></div>';
          }
          img_figure += '</figcaption>';
        }

        img_figure += '</figure>';

        $(this).replaceWith(img_figure);
      });
    },

    /**
     * Add click event to HTML 5 figure and makes it resizable. Add fullscreen
     * icon to image.
     */
    figureResize: function () {
      $("#content figure.left, #content figure.right").each(function (index) {
        $(this).find('> img').css('cursor', 'pointer');

        $(this).find('> img').click(function (event) {
          var left = $(this).parent().hasClass('left');
          var right = $(this).parent().hasClass('right');
          var resized = $(this).parent().hasClass('resized');

          if ((left || right) & !(resized)) {
            $(this).parent().addClass('resized');
          }

          if ((left || right) && (resized)) {
            $(this).parent().removeClass('resized');
          }
        });
      });

      $("#content figure").each(function (index) {
        var body = $('body');
        var img_original = $(this).find('> img');

        if (img_original.hasClass('fullscreen-enabled')) {

          $(this).prepend('<a href="" class="fullscreen"><span class="sr-only">Se i fullskjerm</span></a>');

          $(this).find('.fullscreen').click(function (event) {
            event.preventDefault();

            $('#figure-image-fullscreen').remove();

            var modal = '<!-- Modal fullscreen image -->' +
                '<div class="modal fade" id="figure-image-fullscreen" tabindex="-1" role="dialog" aria-labelledby="figure-image-fullscreen-title" aria-hidden="true">' +
                '  <div class="modal-dialog" role="document">' +
                '    <div class="modal-content">' +
                '      <div class="modal-header">' +
                '        <button type="button" class="close" data-dismiss="modal" style="opacity: 1;">&times;</button>' +
                '        <h4 class="modal-title">' + img_original.attr('title') + '</h4>' +
                '      </div>' +
                '      <div class="modal-body">' +
                '        <img id="fullscreen-image" />' +
                '      </div>' +
                '    </div>' +
                '  </div>' +
                '</div>';

            body.append(modal);

            $('#figure-image-fullscreen').modal('show');

            // Calculate fullscreen image size
            var img = new Image();
            var source;

            if(img_original.attr('data-url-large') != undefined){
              source = "data-url-large";
            } else {
              source = "data-url-img"
            }

            img.src = img_original.attr(source);
            img.onload = function () {
              var fullscreen_img = $('#fullscreen-image');
              fullscreen_img.attr('src', img_original.attr(source));
              fullscreen_img.attr('style', 'width: 100%;');

              var modal_dialog = $('#figure-image-fullscreen .modal-dialog');
              var browserwidth = $(window).width();
              var browserheight = $(window).height();
              var browser_ratio = browserwidth / browserheight;
              var image_ratio = this.naturalWidth / this.naturalHeight;
              var width = 0;

              if (browser_ratio > image_ratio) {
                if (this.naturalHeight > browserheight) {
                  width = (browserheight - 125) * image_ratio;
                }
                else {
                  width = this.naturalWidth;
                }
              }
              else {
                if (this.naturalWidth > browserwidth - 100) {
                  width = browserwidth - 100;
                }
                else {
                  width = this.naturalWidth;
                }

              }

              modal_dialog.width(Math.round(width));
            };
          });
        }
      });
    },

    /**
     * Add click and keypress event to accordion
     */
    accordion: function () {
      $("#content .accordion").each(function (index) {
        // Helper functions
        var helper = {
          removeUrl: function (accordion) {
            accordion.find("iframe").each(function () {
              var iframe = $(this);
              iframe.attr('data-url', iframe.attr('src'));
              iframe.attr('src', '');
            });
          },

          addUrl: function (accordion) {
            accordion.find("iframe").each(function () {
              var iframe = $(this);
              if (iframe.attr('src') == '') {
                iframe.attr('src', iframe.attr('data-url'));
              }
            });
          }
        };

        var accordion = $(this);

        // Prevent loading of iframe and save url in data-url
        helper.removeUrl(accordion);

        accordion.children('.heading').click(function (e) {
          accordion.children('.body').slideToggle("fast", "swing", function () {
            var open = accordion.hasClass('open');

            if (!open) {
              accordion.addClass('open');
            }

            if (open) {
              accordion.removeClass('open');
            }
          });

          // Load saved URL to trigger load of iframe
          helper.addUrl(accordion);
        });

        accordion.keypress(function (event) {
          if (event.which == 13 || event.which == 32) {
            accordion.find('.body').slideToggle("fast", "swing", function () {
              var open = accordion.hasClass('open');

              if (!open) {
                accordion.addClass('open');
              }

              if (open) {
                accordion.removeClass('open');
              }
            });

            // Load saved URL to trigger load of iframe
            helper.addUrl(accordion);
          }
        });

        // Make sure accordion has role and tabindex
        if (!accordion.attr('role')) {
          accordion.attr('role', 'button');
        }
        if (!accordion.attr('tabindex')) {
          accordion.attr('tabindex', '0');
        }

        // If next item is also an accordion, we add class to remove space
        // between the accordions
        var nextAccordion = accordion.next();
        if (nextAccordion.prop('tagName') == 'DIV' && nextAccordion.hasClass('accordion')) {
          accordion.addClass('list');
        }
      });
    },

    /**
     * Add Bootstrap responsive wrapper and css class to HTML table
     */
    tableToResponsive: function () {
      $("#content table, aside table").each(function (index) {
        var table_html = $(this).clone().wrap('<div></div>').parent().html();
        $(this).replaceWith('<div class="table-responsive">' + table_html + '</div>');
      });
    },

    /**
     * Remove Drupal standard file-download icon
     */
    fileDownloadIcon: function () {
      $("#content .file").each(function (index) {
        $(this).find('.file-icon').replaceWith('');
      });
    },

    /**
     * Add click event to article list items
     */
    boxArticleListLink: function () {
      $(".box.article-list.with-hover-and-active article").each(function (index) {
        $(this).click(function () {
          window.location.href = $(this).find('h2 a').attr('href');
        });
      });
    },

    /**
     * Add click event to list items on transport page
     */
    boxTransportPageListLink: function () {
      $(".nodetype-transport .box.menu.transport ul li").each(function (index) {
        $(this).click(function () {
          window.location.href = $(this).find('a').attr('href');
        });
      });
    },

    /**
     * Add scroll to top
     */
    scrollToTop: function () {
      if ($(window).scrollTop() < 100) {
        $('.scroll-to-top').hide();
      }

      $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
          $('.scroll-to-top').fadeIn();
        }
        else {
          $('.scroll-to-top').fadeOut();
        }
      });

      $('.scroll-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 0);
        return false;
      });
    },

    /**
     * Perform action if location.href contains hash (anchor)
     */
    onLocationHash: function () {
      var urlhash = window.location.hash;

      if (urlhash.length > 0) {
        // Get item from hastag
        var item = $(urlhash);

        // If item is an object
        if (item.length) {
          // Item is a closed accordion...open it
          if (item.not('.open').hasClass('accordion')) {
            $(item).find('.heading').trigger("click");
          }
        }
      }
    },

    /**
     * Smooth scrolling to inline anchors
     */
    scrollToAnchor: function () {
      var root = $('html, body');
      var a = $('#content a[href^="#"]').not('.contextual-links-trigger');

      a.click(function () {
        var hash = $.attr(this, 'href');
        var item = $(hash);

        if (item.length) {
          // Change the hash first, then do the scrolling. This retains
          // the standard functionality of the back/forward buttons.
          var scrollmem = $(document).scrollTop();
          window.location.hash = hash;
          $(document).scrollTop(scrollmem);

          // Scroll to anchor
          root.animate({
                scrollTop: item.offset().top - 10
              },
              1000
          );

          window.setTimeout(function () {
            // If target is a closed accordion..open it
            if (item.not('.open').hasClass('accordion')) {
              item.find('.heading').trigger("click");
            }
          }, 1250);

          return false;
        }
      });
    },

    /**
     * Add searchform for mobile
     */
    mobileSearchForm: function () {
      var inst = this;
      var searchToggler = $('header .searchToggler');
      var link = searchToggler.find('a');
      var form = $('header .box.block-search form');

      link.click(function () {
        if (link.attr('data-click-state') == 0 && form.is(":visible")) {
          form.find('.form-text').focus();
          return false;
        }

        if (link.attr('data-click-state') == 1) {
          link.attr('data-click-state', 0);

          $('header > .seperator').show();
          form.slideToggle("fast", "swing");
          link.removeClass('opacity');
        }
        else {
          link.attr('data-click-state', 1);

          $('header > .seperator').hide();
          form.slideToggle("fast", "swing");
          link.addClass('opacity');
          form.find('.form-text').focus();
        }

        return false;
      });

      form.submit(function (event) {
        event.preventDefault();
        window.location.href = Drupal.settings.basePath + 'search/site/' + form.find('.form-text').val();
      });
    },


    /**
     * Set inline videos aspect ratio
     */
    fluidVideoSetAspectRatio: function () {
      var allVideos = $(
          "#content .box.campaign iframe[src*='//player.vimeo.com/'], " +
          "#content .box.campaign iframe[src*='//www.youtube.com/']," +
          "#content .box.campaign iframe[src*='//difi.aventia.no/embed/broadcast/']," +
          "#content article > .body iframe[src*='//player.vimeo.com/'], " +
          "#content article > .body iframe[src*='//www.youtube.com/'], " +
          "#content article > .body iframe[data-url*='//player.vimeo.com/'], " +
          "#content article > .body iframe[data-url*='//www.youtube.com/'], " +
          "#content article > .body iframe[src*='//difi.aventia.no/embed/broadcast/']," +
          "#content article > .body iframe[src*='//vimeo.com/album/']," +
          "#content article > .field iframe[src*='//player.vimeo.com/'], " +
          "#content article > .field iframe[src*='//www.youtube.com/'], " +
          "#content article > .field iframe[data-url*='//player.vimeo.com/'], " +
          "#content article > .field iframe[data-url*='//www.youtube.com/'], " +
          "#content article > .field iframe[src*='//difi.aventia.no/embed/broadcast/']," +
          "#content article > .field iframe[src*='//vimeo.com/album/']"
      );

      allVideos.each(function () {
        var video = $(this);

        if ($.isNumeric(video.attr('height')) && $.isNumeric(video.attr('width'))) {
          video
              .attr('data-aspectRatio', this.height / this.width)
              .removeAttr('height')
              .removeAttr('width');
        }
        else {
          video
              .attr('data-aspectRatio', '0.5625')
              .removeAttr('height')
              .removeAttr('width');
        }

        // Add default player attributes
        if (video.attr('src') && video.attr('src').indexOf('player.vimeo.com/') > -1) {
          video.attr('src', video.attr('src').split("?")[0] + '?title=0&byline=0&portrait=0');
        }
        else if (video.attr('src') && video.attr('src').indexOf('vimeo.com/album/') > -1) {
          video.attr('src', video.attr('src').split("?")[0] + '?title=0&byline=0&portrait=0');
        }
        else if (video.attr('src') && video.attr('src').indexOf('www.youtube.com/') > -1) {
          video.attr('src', video.attr('src').split("?")[0] + '?showinfo=0&disablekb=1');
        }

        if (video.attr('data-url') && video.attr('data-url').indexOf('player.vimeo.com/') > -1) {
          video.attr('data-url', video.attr('data-url').split("?")[0] + '?title=0&byline=0&portrait=0');
        }
        else if (video.attr('data-url') && video.attr('data-url').indexOf('www.youtube.com/') > -1) {
          video.attr('data-url', video.attr('data-url').split("?")[0] + '?showinfo=0&disablekb=1');
        }


        // Check player fullscreen
        if (!video.attr('allowfullscreen')) {
          video.attr('allowfullscreen', 'true');
        }
      });

      this.fluidVideoSetWidthAndHeight();
    },

    /**
     * Set inline video width and height based on aspectratio and fluid
     * container
     */
    fluidVideoSetWidthAndHeight: function () {
      var fluidElement = {
        "videos": [{
          "selector": "#content .box.campaign iframe[src*='//player.vimeo.com/'], " +
          "#content .box.campaign iframe[src*='//www.youtube.com/']",
          "fluidElement": ".body .image"
        },
          {
            "selector": "#content .box.campaign iframe[src*='//player.vimeo.com/'], " +
            "#content .box.campaign iframe[src*='//www.youtube.com/']",
            "fluidElement": ".body .video"
          },
          {
            "selector": "#content .box.campaign iframe[src*='//difi.aventia.no/embed/'], " +
                "#content .box.campaign iframe[src*='//www.youtube.com/']",
            "fluidElement": ".body .video"
          },
          {
            "selector": "#content article > .body iframe[src*='//player.vimeo.com/'], " +
            "#content article > .body iframe[src*='//www.youtube.com/']",
            "fluidElement": ".body"
          },
          {
            "selector": "#content article > .body iframe[data-url*='//player.vimeo.com/'], " +
            "#content article > .body iframe[data-url*='//www.youtube.com/']",
            "fluidElement": ".body"
          },
          {
            "selector": "#content article > .body iframe[src*='//difi.aventia.no/embed/']",
            "fluidElement": ".body"
          },
          {
            "selector":"#content article > .body iframe[src*='//vimeo.com/album/']",
            "fluidElement":".body"
          },
          {
            "selector": "#content article > .field iframe[src*='//player.vimeo.com/'], " +
                "#content article > .field iframe[src*='//www.youtube.com/']",
            "fluidElement": ".field"
          },
          {
            "selector": "#content article > .field iframe[data-url*='//player.vimeo.com/'], " +
                "#content article > .field iframe[data-url*='//www.youtube.com/']",
            "fluidElement": ".field"
          },
          {
            "selector": "#content article > .field iframe[src*='//difi.aventia.no/embed/']",
            "fluidElement": ".field"
          },
          {
            "selector":"#content article > .field iframe[src*='//vimeo.com/album/']",
            "fluidElement":".field"
          },
        ]
      };

      var helper = {
        setWidthAndHeight: function (selector, fluidElement) {
          var allVideos = $(selector);

          allVideos.each(function () {
            var el = $(this);
            el.width(0).height(0); // Reset width and height
            var fluidEl = el.closest(fluidElement);
            var newWidth = fluidEl.width();

            // Hack...if the fluid element is not visible..getting width will
            // not be correct. Solution is to clone the hidden fluid element,
            // override display, get width and then remove the cloned item....
            if (fluidEl.is(":visible") == false) {
              var clone = fluidEl.clone();
              clone.css({display: "block"});
              fluidEl.parent().append(clone);
              newWidth = clone.width();
              clone.remove();
            }

            if(el.attr('data-aspectRatio') === undefined){
              el.width(newWidth).height(newWidth / 1.77);
              el.attr('width', newWidth).attr('height', newWidth / 1.77);
            } else {
              el.width(newWidth).height(newWidth * el.attr('data-aspectRatio'));
              el.attr('width', newWidth).attr('height', newWidth * el.attr('data-aspectRatio'));
            }
          });
        }
      };

      var i;
      for (i = 0; i < fluidElement.videos.length; i++) {
        helper.setWidthAndHeight(fluidElement.videos[i].selector, fluidElement.videos[i].fluidElement);
      }
    },

    /**
     * Keyfigures (nøkkeltall)
     *
     */
    keyfigure: function () {
      $("article > .body .keyfigure").each(function (index) {
        var keyfigure = $(this);
        var fact = keyfigure.find('.fact');
        var description = keyfigure.find('.description');

        // If next item is also a keyfigure, we add class to remove space
        // between the figures
        var nextKeyfigure = keyfigure.next();
        if (nextKeyfigure.prop('tagName') == 'DIV' && nextKeyfigure.hasClass('keyfigure')) {
          keyfigure.addClass('list');
        }

        // If no fact present show description in full with
        if (fact.hasClass('element-invisible')) {
          description.addClass('full-width');
          description.addClass('display-table-cell');
        }
      });
    },

    /**
     * Nodetype list
     *
     */
    listPage: function () {
      // Skjule filter container dersom filter er skjult for brukar
      var filter = $(".nodetype-list .box.article-list .body .view-filters");

      if (filter.find('> div.hidden').length > 0) {
        filter.addClass('hidden');
      }
    },

    /**
     * Check for accepted privacy cookie info
     */
    euCookiePrivacy: function () {
      var helper = {
        getCookie: function (cname) {
          var name = cname + "=";
          var ca = document.cookie.split(';');
          for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
              c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
              return c.substring(name.length, c.length);
            }
          }
          return "";
        },

        setCookie: function (cname, cvalue, exdays) {
          var d = new Date();
          d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
          var expires = "expires=" + d.toUTCString();
          var path = "path=/";
          document.cookie = cname + "=" + cvalue + "; " + expires + "; " + path;
        }
      };

      var privacyUrl = '';

      try {
        privacyUrl = Drupal.settings.difino_base.difi_footer_privacy;
      }
      catch (e) {
        privacyUrl = 'https://www.difi.no/om-difi/personvernerklaering';

        if (e instanceof TypeError) {
          return false;
        }
      }


      /* DISABLED IDURT-93019

      if (helper.getCookie('cb-enable') != 'accepted') {
        var html = '<div id="cookie-bar">' +
            '<div class="wrapper">' +
            '<p>' +
            '<a href="" class="cb-enable">Lukk</a>' +
            'Denne siden benytter seg av informasjonskapsler (cookies). Du kan fortsette å bruke siden som vanlig hvis du godtar dette. ' +
            '<a href="' + privacyUrl + '">Les mer om bruk av informasjonskapsler i vår personvernerklæring.</a>' +
            '</p>' +
            '</div>' +
            '</div>';

        $('body').append(html);

        var cb = $('#cookie-bar');
        var close = $('#cookie-bar .cb-enable');
        close.click(function () {
          helper.setCookie('cb-enable', 'accepted', 365);
          cb.fadeOut("slow");
          return false;
        });
      }

      */

    },

    /**
     * Add divs to body that can be used to detect Bootstrap modus (device
     * modus)
     */
    addBootstrapBreakpointDetection: function () {
      $('body').append('<div class="device-xs visible-xs"></div><div class="device-sm visible-sm"></div><div class="device-md visible-md"></div><div class="device-lg visible-lg"></div>');
    },

    /**
     * @returns
     * true  - if page is currently using the breakpoint specified as argument
     * false  - if otherwise
     */
    isBootstrapBreakpoint: function (alias) {
      return $('.device-' + alias).is(':visible');
    },

    /**
     * Add warning to user...what environment this is
     */
    warningEnvironment: function () {
      var host = window.location.host;
      // debug
      // host = 'ver-drupal.difi.local';
      var environment = '';

      if (host.match(/dev-drupal/)) {
        environment = 'UTVIKLING';
      }
      else if (host.match(/test-drupal/) || host.match(/des-drupal/)) {
        environment = 'TEST';
      }
      else if (host.match(/ver-drupal/) || host.match(/for-drupal/)) {
        environment = 'VERIFIKASJON';
      }

      if (environment != '') {
        var page = $('#page');
        page.prepend('<div class="environment-overlay" title="Til informasjon:\n\nDu jobber nå på Difi sitt ' + environment + 'SMILJØ for Drupal!!!"><span>' + environment + '</span></div>');
        page.find('.environment-overlay').css({
          "position": "fixed",
          "background": "red",
          "color": "black",
          "display": "grid",
          "align-content": "center",
          "font-family": "Open Sans, sans-serif",
          "font-weight": "700",
          "text-align": "center",
          "font-size": "0.75em",
          "z-index": "995",
          "top": "25px",
          "min-width": "120px",
          "background-color": "rgba(255, 0, 0, 0.60)",
          "border": "solid 2px black",
          "padding": "5px"
        });

        // Check if admin menu is visible...then add some margin
        try {
          if (Drupal.settings.admin_menu) {
            page.find('.environment-overlay').css({"margin-top": "25px"});
          }
        }
        catch (e) {
          if (e instanceof TypeError) {
            return false;
          }
        }
      }
    },

    /**
     * Alphabetic sitemap
     */
    sitemapAlphabeticNavigation: function () {
      var navigationlist = $(".sitemap-navigation-alphabetic ul");
      var resultlist = $(".dificontainer.toc.sitemap-alphabetic ul");

      $(navigationlist).find("li").each(function (g) {
        var li = $(this);
        var a = li.find("a");
        var letter = a.text()[0];
        var filter = "";

        if (a.text() == "ALT") {
        }
        else {
          if (a.text() == "TALL") {
            filter = a.text();
          }
          else {
            filter = letter;
          }
        }

        if (filter != "") {
          if (resultlist.find("li").hasClass(filter) == false) {
            a.remove();
            li.text(filter);
          }
        }
      });

      $(navigationlist).find("li a").on("click", function () {
        event.preventDefault();
        var a = $(this);
        var letter = a.text()[0];
        var filter = "";

        if (a.text() == "ALT") {
          $(resultlist).find("li").each(function () {
            $(this).show();
          });
        }
        else {
          if (a.text() == "TALL") {
            filter = a.text();
          }
          else {
            filter = letter;
          }
        }

        if (filter != "") {
          $(resultlist).find("li").each(function () {
            if ($(this).hasClass(filter)) {
              $(this).show();
            }
            else {
              $(this).hide();
            }
          });
        }
      });
    },

    /***
     * Add bootstrap popover
     */
    popover: function () {
      $('[data-toggle="popover"]').popover();
    },

    /**
     * Add window resize
     */
    resizer: function () {
      var inst = this;
      $(window).on('resize', function (e) {
        inst.fluidVideoSetWidthAndHeight();
      });
    },
  };

  /**
   * Document ready...here we go!
   */
  $(document).ready(function () {
    Difi3.init();
  });
});