jQuery(function ($) {
	
	var Difi3_difino = {			
			config: {},
			
			init: function (config) {
				this.bloggPageSetActiveTaxonomyTerm();
				this.processNumberOfPhases();
				this.processNumbering();
				this.facetapiAdjustHtml();
			},
			
			/**
			 * Blog and blogpage taxonomy
			 */
			bloggPageSetActiveTaxonomyTerm: function() {
				var inst = this;
				
				// Uthevar valgt emneord
				$( ".box.blogg-emneord .body ul li" ).each(function( index ) {
					if ($(this).find('a').attr('href').match(/[\d]+$/) == inst.getUrlParameter('field_taxonomy_emneord_tid')) {
						$(this).css('font-weight', '700');
					}
				});
				
				// Legg til "Vis alle tema"
				$( ".box.blogg-emneord .body ul" ).append(
					$('<li>').attr('class','more').append(
						$('<a>').attr('href', 'http://' + window.location.hostname + Drupal.settings.basePath + Drupal.settings.difino_base.difino_config_bloglist_path).append('Vis alle tema »')
					)
				);
				
				// Dersom ingen emneord er valgt så set vi "Vis alle tema" til utheva
				if (window.location.search.substring(1) == '') {
					$( ".box.blogg-emneord .body ul li:last" ).css('font-weight', '700');
				}				
			},
			
			/**
			 * Process horizontal menu numbering
			 */
			processNumberOfPhases: function() {
				var numberOfPhases = $( ".box.menu.process-horizontal .body ul li" ).length;		
				
				$( ".box.menu.process-horizontal .body ul li" ).each(function( index, value ) {
					$(this).addClass('number-of-phases-' + numberOfPhases);
				});				
			},
			
			/**
			 * Process vertical menu numbering
			 */			
			processNumbering: function() {
				var inst = this;
				var processPhaseNumber = $( ".box.menu.process-horizontal .body ul li.active-trail a .number").text() + '.';

				var processStepIndex = 1;
				var processSubStepIndex;

				$( ".box.menu.process-vertical .body > ul > li" ).each(function( stepIndex, stepValue ) {

          if($(this).hasClass("square") || $(this).hasClass("circle") || $(this).hasClass("number"))  {
            $(this).find('> a').prepend(processStepIndex.toString().bold() + '. ');
            processStepIndex++;
          }

          processSubStepIndex = 1;

          $(this).find('> ul > li').each(function (subStepIndex, subStepValue) {

            if($(this).hasClass("square") || $(this).hasClass("circle") || $(this).hasClass("number")) {
              $(this).find('> a').prepend(processSubStepIndex.toString().bold() + '. ');
              processSubStepIndex++;
            }
          });

          processSubStepIndex = 1;

          $(this).find('> ul > li > ul > li').each(function (subStepIndex, subStepValue) {
            if($(this).hasClass("square") || $(this).hasClass("circle") || $(this).hasClass("number")) {
              $(this).find('> a').prepend(processSubStepIndex.toString().bold() + '. ');
              processSubStepIndex++;
            }
          });

          processSubStepIndex = 1;

          $(this).find('> ul > li > ul > li > ul > li').each(function (subStepIndex, subStepValue) {
            if($(this).hasClass("square") || $(this).hasClass("circle") || $(this).hasClass("number")) {
              $(this).find('> a').prepend(processSubStepIndex.toString().bold() + '. ');
              processSubStepIndex++;
            }
          });
        });
			},
			
			/**
			 * Modify facetapi HTML
			 *
			 * Change Drupal facetapi UL/LI html
			 */
			facetapiAdjustHtml: function() {
        $( "aside .box.block-facetapi a.facetapi-active" ).each(function( index ) {
          var a = $(this);
          var li = $(a.parent());

          var new_a_text = li.contents().not(li.children()).text();
          li.contents().not(li.children()).remove();

          a.contents().not(a.children()).remove();
          a.text(new_a_text);
        });
			},			
			
			/**
			 * Get URL parameter
			 */			
			getUrlParameter: function(sParam, sPageURL) {
			    var sPageURL = window.location.search.substring(1);
			    var sURLVariables = sPageURL.split('&');
			    for (var i = 0; i < sURLVariables.length; i++) 
			    {
			        var sParameterName = sURLVariables[i].split('=');
			        if (sParameterName[0] == sParam) 
			        {
			            return sParameterName[1];
			        }
			    }				
			},
			
			/**
			 * Convert number to small letter
			 */			
			toLetters: function(num) {
		    var mod = num % 26,
		        pow = num / 26 | 0,
		        out = mod ? String.fromCharCode(96 + mod) : (--pow, 'Z');
		    return pow ? toLetters(pow) + out : out;
			},
	};
	
	/**
	 * Document ready...here we go!
	 */
	$(document).ready(function() { Difi3_difino.init(); });	
});