<?php
if ( ! defined( 'MEDIAWIKI' ) )
    die();
/*
 
 Purpose:       Have certain namespaces whitelisted so 
                that they can be read, regardless of
                if the user has permission to read.
 
                For example, a public namespace, on
                a private wiki.
 
 @author n:en:User:Bawolff <http://en.wikinews.org/wiki/User:Bawolff>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or 
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc.,
 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 http://www.gnu.org/copyleft/gpl.html
 
 
 To install, add following to LocalSettings.php
   require_once("extensions/WhitelistNamespaces.php");
   $egNamespaceReadWhitelist = Array();
 
 Note, the order of those lines are important
 
 changing the $egNamespaceReadWhitelist = Array(); to be an array of namespaces
 you want to whitelist. ex: 
   $egNamespaceReadWhitelist = Array(NS_TALK, NS_MAIN, NS_HELP);
 for main help and talk namespaces.
 
 
Note this will not work if the wiki is world readable. You must
make the wiki not readable (ex $wgGroupPermissions['*']['read']=true;)
before you can whitelist a namespace as readable.
*/
 
 
$egNamespaceReadWhitelist = Array(); #default. overide in LocalSettings.php

$wgHooks['userCan'][] = 'efExtensionWhitelistNamespaces';
$wgExtensionCredits['other'][] = array(
        'name' => 'Whitelist Namespaces',
        'description' => 'Allows an entire namespace to be read-whitelisted',
        'url' => 'http://www.mediawiki.org/wiki/Extension:Whitelist_Namespaces',
        'author' => '[http://en.wikinews.org/wiki/user:Bawolff Bawolff]',
        'version' => '0.1-1'
);
 
 
function efExtensionWhitelistNamespaces(&$title, &$user, $action, &$result) {
        global $egNamespaceReadWhitelist;
        if ($action == 'read') {
                if( in_array($title->getNamespace(), $egNamespaceReadWhitelist, true)) {
                        $result = true;
                        return false;
                }
        }
        return true;
 
}