<?php
## MobileSkin.php - Register the extension

# Needs to be called within MediaWiki; not standalone
if ( !defined('MEDIAWIKI') ) {
	echo("This is an extension to the MediaWiki package and cannot be run standalone.\n" );
	die(-1);
}
 
# Define the extension; allows us make sure the extension is used correctly
DEFINE( 'MOBILESKIN', 'MobileSkin' );
 
# Identify the extension, version, author, etc 
$wgExtensionCredits['parserhook'][] = array(
        'name'          =>      MOBILESKIN,
        'version'       =>      '0.3 2009-04-30',
        'author'        =>      'Mark Daly',
        'url'           =>      'http://www.mediawiki.org/wiki/Extension:MobileSkin',
        'description'   =>      'Automatically switch skins based on user device without affecting user\'s preference.'
);
 
# Set up extension and hook for the event handler (ev)
$wgHooks['BeforePageDisplay'][] = 'evMobileSkin_Setup';
 
# Pull in language/messages (if found)
if (file_exists(dirname(__FILE__) . '/MobileSkin.i18n.php'))
	$wgExtensionMessagesFiles['mobileskin'] = dirname(__FILE__) . '/MobileSkin.i18n.php';
 
# Pull in main code
require_once ( dirname(__FILE__) . '/MobileSkin.body.php' );
 
# Event handler
function evMobileSkin_Setup ( &$out, &$sk ) {
	$ms = new MobileSkin;
	return $ms->changeSkin( $out, $sk );
} # function evMobileSkin_Setup

# Additional functions for other extensions or LocalSettings.php
function is_mobile() {
	$m = new MobileSkin;
	return $m->isMobile();
} # function is_mobile

# Example use
function get_mobileName() {
	$m = new MobileSkin;
	return $m->getMobileDevice();
} # function get_mobileName
